unit DataSoap;

interface

uses SysUtils, Classes, InvokeRegistry, Midas, SOAPMidas, SOAPDm;

type
  IdmSoap = interface(IAppServerSOAP)
    ['{EA7223AD-FB1B-435C-ABDB-4E2AE6FB9974}']
  end;

  TDMSoap = class(TSoapDataModule, IdmSoap, IAppServerSOAP, IAppServer)
    procedure SoapDataModuleCreate(Sender: TObject);
    procedure SoapDataModuleDestroy(Sender: TObject);
  private
    procedure RegisterLocalProvider;
    procedure UnregisterLocalProvider;

  public

  end;

implementation

uses DmLista, Provider;

{$R *.DFM}

procedure TdmSoapCreateInstance(out obj: TObject);
begin
 obj := TdmSoap.Create(nil);
end;

procedure TDMSoap.SoapDataModuleCreate(Sender: TObject);
begin
  RegisterLocalProvider;
end;

procedure TdmSoap.RegisterLocalProvider;
var
  vI, vJ: integer;
begin
  for vI := 0 to vDmLista.Count - 1 do
  begin
    with TDataModule(vDmLista[vI]) do
    begin
      for vJ := 0 to ComponentCount -1 do
        if Components[vJ] is TDataSetProvider then
          RegisterProvider(TDataSetProvider(Components[vJ]));
    end;
  end;
end;

procedure TdmSoap.UnregisterLocalProvider;
var
  vI,vJ : integer;
begin
  if ProviderCount > 0 then
    for vI := 0 to vDmLista.Count - 1 do
    begin
      with TDataModule(vDmLista[vI]) do
      begin
        for vJ := 0 to ComponentCount -1 do
          if Components[vJ] is TDataSetProvider then
           UnRegisterProvider(TDataSetProvider(Components[vJ]));
      end;
    end;
end;

procedure TDMSoap.SoapDataModuleDestroy(Sender: TObject);
begin
  UnregisterLocalProvider;
end;

initialization
   InvRegistry.RegisterInvokableClass(TDMSoap, TdmSoapCreateInstance);
   InvRegistry.RegisterInterface(TypeInfo(IdmSoap));
end.
